/* global colorScheme, Color */
/**
 * Add a listener to the Color Scheme control to update other color controls to new values/defaults.
 * Also trigger an update of the Color Scheme CSS when a color is changed.
 */
( function( api ) {
	var cssTemplate = wp.template( 'sekolah-color-scheme' ),
		colorSchemeKeys = [
			'background_color',
			'sekolah_color1',
			'sekolah_color2',
			'sekolah_color3',
			'sekolah_color4',
			'sekolah_color5',
			'sekolah_color6',
			'sekolah_color7',
			'sekolah_color8',
			'sekolah_color9',
			'sekolah_color10',
			'sekolah_color11',
			'sekolah_color12',
			'sekolah_color13',
			'sekolah_color14',
			'sekolah_color15',
			'sekolah_color16',
			'sekolah_color17',
			'sekolah_color18',
			'sekolah_color19',
			'sekolah_color20',
			'sekolah_color21',
			'sekolah_color22',
			'sekolah_color23',
			'sekolah_color22',
			'sekolah_color31',
			'sekolah_color32',
			'sekolah_color33',
			'sekolah_color34',
			'sekolah_color35',
			'sekolah_color36',
		],
		colorSettings = [
			'background_color',
			'sekolah_color1',
			'sekolah_color2',
			'sekolah_color3',
			'sekolah_color4',
			'sekolah_color5',
			'sekolah_color6',
			'sekolah_color7',
			'sekolah_color8',
			'sekolah_color9',
			'sekolah_color10',
			'sekolah_color11',
			'sekolah_color12',
			'sekolah_color13',
			'sekolah_color14',
			'sekolah_color15',
			'sekolah_color16',
			'sekolah_color17',
			'sekolah_color18',
			'sekolah_color19',
			'sekolah_color20',
			'sekolah_color21',
			'sekolah_color22',
			'sekolah_color23',
			'sekolah_color24',
			'sekolah_color25',
			'sekolah_color26',
			'sekolah_color27',
			'sekolah_color28',
			'sekolah_color29',
			'sekolah_color30',
			'sekolah_color31',
			'sekolah_color32',
			'sekolah_color33',
			'sekolah_color34',
			'sekolah_color35',
			'sekolah_color36',
		];
	api.controlConstructor.select = api.Control.extend( {
		ready: function() {
			if ( 'color_scheme' === this.id ) {
				this.setting.bind( 'change', function( value ) {
					var colors = colorScheme[value].colors;
					// Update Background Color.
					var color = colors[0];
					api( 'background_color' ).set( color );
					api.control( 'background_color' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					// Update Page Background Color.
					color = colors[1];
					api( 'sekolah_color1' ).set( color );
					api.control( 'sekolah_color1' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					// Update Link Color.
					color = colors[2];
					api( 'sekolah_color2' ).set( color );
					api.control( 'sekolah_color2' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					// Update Main Text Color.
					color = colors[3];
					api( 'sekolah_color3' ).set( color );
					api.control( 'sekolah_color3' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					// Update Secondary Text Color.
					color = colors[4];
					api( 'sekolah_color4' ).set( color );
					api.control( 'sekolah_color4' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					
					color = colors[5];
					api( 'sekolah_color5' ).set( color );
					api.control( 'sekolah_color5' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[6];
					api( 'sekolah_color6' ).set( color );
					api.control( 'sekolah_color6' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
						
					color = colors[7];
					api( 'sekolah_color7' ).set( color );
					api.control( 'sekolah_color7' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[8];
					api( 'sekolah_color8' ).set( color );
					api.control( 'sekolah_color8' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
						
					color = colors[9];
					api( 'sekolah_color9' ).set( color );
					api.control( 'sekolah_color9' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[10];
					api( 'sekolah_color10' ).set( color );
					api.control( 'sekolah_color10' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[11];
					api( 'sekolah_color11' ).set( color );
					api.control( 'sekolah_color11' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[12];
					api( 'sekolah_color12' ).set( color );
					api.control( 'sekolah_color12' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[13];
					api( 'sekolah_color13' ).set( color );
					api.control( 'sekolah_color13' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[14];
					api( 'sekolah_color14' ).set( color );
					api.control( 'sekolah_color14' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[15];
					api( 'sekolah_color15' ).set( color );
					api.control( 'sekolah_color15' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[16];
					api( 'sekolah_color16' ).set( color );
					api.control( 'sekolah_color16' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[17];
					api( 'sekolah_color17' ).set( color );
					api.control( 'sekolah_color17' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[18];
					api( 'sekolah_color18' ).set( color );
					api.control( 'sekolah_color18' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[19];
					api( 'sekolah_color19' ).set( color );
					api.control( 'sekolah_color19' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[20];
					api( 'sekolah_color20' ).set( color );
					api.control( 'sekolah_color20' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[21];
					api( 'sekolah_color21' ).set( color );
					api.control( 'sekolah_color21' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[22];
					api( 'sekolah_color22' ).set( color );
					api.control( 'sekolah_color22' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[23];
					api( 'sekolah_color23' ).set( color );
					api.control( 'sekolah_color23' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[24];
					api( 'sekolah_color24' ).set( color );
					api.control( 'sekolah_color24' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[25];
					api( 'sekolah_color25' ).set( color );
					api.control( 'sekolah_color25' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[26];
					api( 'sekolah_color26' ).set( color );
					api.control( 'sekolah_color26' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[27];
					api( 'sekolah_color27' ).set( color );
					api.control( 'sekolah_color27' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[28];
					api( 'sekolah_color28' ).set( color );
					api.control( 'sekolah_color28' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[29];
					api( 'sekolah_color29' ).set( color );
					api.control( 'sekolah_color29' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[30];
					api( 'sekolah_color30' ).set( color );
					api.control( 'sekolah_color30' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[31];
					api( 'sekolah_color31' ).set( color );
					api.control( 'sekolah_color31' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[32];
					api( 'sekolah_color32' ).set( color );
					api.control( 'sekolah_color32' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[33];
					api( 'sekolah_color33' ).set( color );
					api.control( 'sekolah_color33' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[34];
					api( 'sekolah_color34' ).set( color );
					api.control( 'sekolah_color34' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[35];
					api( 'sekolah_color35' ).set( color );
					api.control( 'sekolah_color35' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
					color = colors[36];
					api( 'sekolah_color36' ).set( color );
					api.control( 'sekolah_color36' ).container.find( '.color-picker-hex' )
						.data( 'data-default-color', color )
						.wpColorPicker( 'defaultColor', color );
				} );
			}
		}
	} );
	// Generate the CSS for the current Color Scheme.
	function updateCSS() {
		var scheme = api( 'color_scheme' )(),
			css,
			colors = _.object( colorSchemeKeys, colorScheme[ scheme ].colors );
		// Merge in color scheme overrides.
		_.each( colorSettings, function( setting ) {
			colors[ setting ] = api( setting )();
		} );
		
		css = cssTemplate( colors );
		api.previewer.send( 'update-color-scheme-css', css );
	}
	// Update the CSS whenever a color setting is changed.
	_.each( colorSettings, function( setting ) {
		api( setting, function( setting ) {
			setting.bind( updateCSS );
		} );
	} );
} )( wp.customize );