<?php 
	register_post_type( 'agenda',		
	array(			
	    'menu_icon'       => 'dashicons-calendar-alt',
		'labels'          => array(				
	    'name'                => 'Agenda',				
	    'singular_name'       => 'Agenda',        
	    'add_new'             => 'Tambah Agenda?',	
	    'add_new_item'        => 'Tambah Agenda',	
	    'edit'                => 'Edit',	 
	    'edit_item'           => 'Edit Agenda',	
	    'new_item'            => 'Item Baru',	
	    'view'                => 'Lihat Agenda',	
	    'view_item'           => 'Lihat Item',	
	    'search_items'        => 'Cari Item',	
	    'not_found'           => 'Tidak ada Agenda ditemukan',	
	    'not_found_in_trash'  => 'Tidak ada Agenda di folder Trash',	
	    'parent'              => 'Parent Super Duper',
        'featured_image'      => 'Gambar 600 x 400',		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor', 'thumbnail'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
		 )	
    );
	
	add_action('admin_init', 'agenda_tutorial', 1);
	
	function agenda_tutorial() {
	    add_meta_box('agendatutorial', 'Tutorial Pengelolaan Pos Agenda', 'agendatutorial', 'agenda', 'normal', 'default');
	}

	function agendatutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://ciuss.com/tuts-agenda/' ); ?>
		</div>
    
	<?php }
	
	add_action('admin_init', 'masevents', 1);
	
	function masevents() {
	    add_meta_box('agenda_events', 'Data Agenda', 'agenda_events', 'agenda', 'normal', 'default');
	}
	function agenda_events() {
	    global $post;
	    echo '<input type="hidden" name="eventmeta_noncename" id="eventmeta_noncename" value="' .esc_attr(
	    wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';
        
		$minus = strtotime(get_post_meta($post->ID, '_tevent', true));
	    $tevent = get_post_meta($post->ID, '_tevent', true);
	    $jam = get_post_meta($post->ID, '_jam', true);
		$lokasi = get_post_meta($post->ID, '_lokasi', true);
		$roomaps = get_post_meta($post->ID, '_roomaps', true);
		$hariini = strtotime(date("Y-m-d"));
		$sekarang = strtotime(date("Y-m-d"));
		$currents = $sekarang-$minus;
		?>
		    
		<div class="sekolah_metabox">
		
			<label><?php echo  'Tanggal Agenda'; ?></label>
			<input type="date" name="_tevent" value="<?php echo esc_attr( $tevent ); ?>" class="widefat" />
		
		    <label><?php echo  'Time (example 08:30 AM)'; ?></label>
			<input type="time" name="_jam" value="<?php echo esc_attr( $jam ); ?>" class="widefat" />
			
			<label><?php echo  'Location'; ?></label>
			<input type="text" name="_lokasi" value="<?php echo esc_attr( $lokasi ); ?>" class="widefat" />
			
			<label><?php echo  'Embed Maps'; ?></label>
			<textarea name="_roomaps" class="widefat"><?php echo esc_textarea( $roomaps ); ?></textarea><br/><br/>
			
		</div>
    
	<?php }
	function agenda_events_meta($post_id, $post) {
		
	    if ( ! isset( $_POST['eventmeta_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['eventmeta_noncename'] ) ), plugin_basename(__FILE__) )) {
	        return $post->ID;
	    }
	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
		
		if ( ! isset( $_POST['_tevent'] ) ) {
	    	$events_meta['_minus'] = strtotime(sanitize_text_field(wp_unslash($_POST['_tevent'])));
	        $events_meta['_tevent'] = sanitize_text_field(wp_unslash($_POST['_tevent']));
		} else {
			$events_meta['_minus'] = strtotime(sanitize_text_field(wp_unslash($_POST['_tevent'])));
	        $events_meta['_tevent'] = sanitize_text_field(wp_unslash($_POST['_tevent']));
		}
		if ( ! isset( $_POST['_jam'] ) ) {
	    	$events_meta['_jam'] = sanitize_text_field(wp_unslash($_POST['_jam']));
		} else {	
	    	$events_meta['_jam'] = sanitize_text_field(wp_unslash($_POST['_jam']));
		}
		if ( ! isset( $_POST['_lokasi'] ) ) {
	    	$events_meta['_lokasi'] = sanitize_text_field(wp_unslash($_POST['_lokasi']));
		} else {
			$events_meta['_lokasi'] = sanitize_text_field(wp_unslash($_POST['_lokasi']));
		}
		if ( ! isset( $_POST['_roomaps'] ) ) {
	    	$events_meta['_roomaps'] = sanitize_text_field(wp_unslash($_POST['_roomaps']));
		} else {
			$events_meta['_roomaps'] = sanitize_text_field(wp_unslash($_POST['_roomaps']));
		}
		
	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }
	}
	add_action('save_post', 'agenda_events_meta', 1, 2); 
	
?>