<?php
    
	
	register_post_type( 'dosen',		
	array(			
	    'menu_icon'       => 'dashicons-businessperson',
	    'labels'          => array(				
	    'name'                => 'Dosen',				
	    'singular_name'       => 'Dosen',        
	    'add_new'             => 'Tambah Dosen?',	
	    'add_new_item'        => 'Tambah Dosen',	
	    'edit'                => 'Edit',	 
	    'edit_item'           => 'Edit Dosen',	
	    'new_item'            => 'Item Baru',	
	    'view'                => 'Lihat Dosen',	
	    'view_item'           => 'Lihat Item',	
	    'search_items'        => 'Cari Item',	
	    'not_found'           => 'Tidak ada Dosen ditemukan',	
	    'not_found_in_trash'  => 'Tidak ada Dosen di folder Trash',	
	    'parent'              => 'Parent Super Duper',
        'featured_image'      => 'Pas Photo 300 x 400',		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
		 )	
    );
	
	add_action('admin_init', 'dosen_tutorial', 1);
	 
	function dosen_tutorial() {
	    add_meta_box('dosentutorial', 'Tutorial Pengelolaan Pos Dosen', 'dosentutorial', 'dosen', 'normal', 'default');
	}

	function dosentutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://ciuss.com/tuts-guru/' ); ?>
		</div>
    
	<?php }
	
	add_action('admin_init', 'guru', 1);
	
	function guru() {
	    add_meta_box('guru_data', 'Diodata Dosen', 'guru_data', 'dosen', 'normal', 'default');
	}
	function guru_data() {
	    global $post;
	    echo '<input type="hidden" name="gtk_noncename" id="gtk_noncename" value="' .esc_attr(
	    wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';
	    $nik = get_post_meta($post->ID, '_nik', true);
		$nip = get_post_meta($post->ID, '_nip', true);
		$nuptk = get_post_meta($post->ID, '_nuptk', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$waguru = get_post_meta($post->ID, '_waguru', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$akademifb = get_post_meta($post->ID, '_akademifb', true);
		$akademitw = get_post_meta($post->ID, '_akademitw', true);
		$akademiig = get_post_meta($post->ID, '_akademiig', true);
		
		?>
		<div class="sekolah_metabox">
		
		    <label><?php echo  'NIDN'; ?></label>
	        <input type="text" name="_nik" value="<?php echo esc_attr( $nik ); ?>" class="widefat" />
			
			<label><?php echo  'NIY'; ?></label>
	        <input type="text" name="_nip" value="<?php echo esc_attr( $nip ); ?>" class="widefat" />
			
			<label><?php echo  'NUPTK'; ?></label>
			<input type="text" name="_nuptk" value="<?php echo esc_attr( $nuptk ); ?>" class="widefat" />
			
			<label><?php echo  'Jenis Kelamin'; ?></label>
			<input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo  'Tempat Lahir (contoh: Lampung)'; ?></label>
			<input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo  'Tanggal Lahir'; ?></label>
			<input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo  'Agama : (Islam, Kristen, Katholik, Hindu, Budha, Konghucu, Lain-lain)'; ?></label>
			<input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo  'Alamat'; ?></label>
			<input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
			
			<label><?php echo  'Telepon'; ?></label>
			<input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo  'WhatsApp (awali dengan 62)'; ?></label>
			<input type="text" name="_waguru" placeholder="<?php echo echo '62...'; ?>" value="<?php echo esc_attr( $waguru ); ?>" class="widefat" />
			
			<label><?php echo  'Email'; ?></label>
			<input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<label><?php echo  'Facebook'; ?></label>
			<input type="text" name="_akademifb" value="<?php echo esc_attr( $akademifb ); ?>" class="widefat" />
			
			<label><?php echo  'Twitter'; ?></label>
			<input type="text" name="_akademitw" value="<?php echo esc_attr( $akademitw ); ?>" class="widefat" />
			
			<label><?php echo  'Instagram'; ?></label>
			<input type="text" name="_akademiig" value="<?php echo esc_attr( $akademiig ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function guru_data_meta($post_id, $post) {
	    if ( ! isset( $_POST['gtk_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['gtk_noncename'] ) ), plugin_basename(__FILE__) )) {
	    return $post->ID;
	    }
	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
		
		if ( ! isset( $_POST['_nik'] ) ) {
	        $akademiguru['_nik'] = sanitize_text_field(wp_unslash( $_POST['_nik'] ) );
		} else {
	        $akademiguru['_nik'] = sanitize_text_field(wp_unslash( $_POST['_nik'] ) );
		}
		if ( ! isset( $_POST['_nip'] ) ) {
	        $akademiguru['_nip'] = sanitize_text_field(wp_unslash( $_POST['_nip'] ) );
		} else {
	        $akademiguru['_nip'] = sanitize_text_field(wp_unslash( $_POST['_nip'] ) );
		}
		if ( ! isset( $_POST['_nuptk'] ) ) {
	    	$akademiguru['_nuptk'] = sanitize_text_field(wp_unslash( $_POST['_nuptk'] ) );
		} else {
	        $akademiguru['_nuptk'] = sanitize_text_field(wp_unslash( $_POST['_nuptk'] ) );
		}
		if ( ! isset( $_POST['_sex'] ) ) {
	    	$akademiguru['_sex'] = sanitize_text_field(wp_unslash( $_POST['_sex'] ) );
		} else {
	        $akademiguru['_sex'] = sanitize_text_field(wp_unslash( $_POST['_sex'] ) );
		}
		if ( ! isset( $_POST['_tmpt'] ) ) {
	    	$akademiguru['_tmpt'] = sanitize_text_field(wp_unslash( $_POST['_tmpt'] ) );
		} else {
	        $akademiguru['_tmpt'] = sanitize_text_field(wp_unslash( $_POST['_tmpt'] ) );
		}
		if ( ! isset( $_POST['_tgl'] ) ) {
	    	$akademiguru['_tgl'] = sanitize_text_field(wp_unslash( $_POST['_tgl'] ) );
		} else {
	        $akademiguru['_tgl'] = sanitize_text_field(wp_unslash( $_POST['_tgl'] ) );
		}
		if ( ! isset( $_POST['_rel'] ) ) {
	    	$akademiguru['_rel'] = sanitize_text_field(wp_unslash( $_POST['_rel'] ) );
		} else {
	        $akademiguru['_rel'] = sanitize_text_field(wp_unslash( $_POST['_rel'] ) );
		}
		if ( ! isset( $_POST['_add'] ) ) {
	    	$akademiguru['_add'] = sanitize_text_field(wp_unslash( $_POST['_add'] ) );
		} else {
	        $akademiguru['_add'] = sanitize_text_field(wp_unslash( $_POST['_add'] ) );
		}
		if ( ! isset( $_POST['_telp'] ) ) {
	    	$akademiguru['_telp'] = sanitize_text_field(wp_unslash( $_POST['_telp'] ) );
		} else {
	        $akademiguru['_telp'] = sanitize_text_field(wp_unslash( $_POST['_telp'] ) );
		}
		if ( ! isset( $_POST['_waguru'] ) ) {
	    	$akademiguru['_waguru'] = sanitize_text_field(wp_unslash( $_POST['_waguru'] ) );
		} else {
	        $akademiguru['_waguru'] = sanitize_text_field(wp_unslash( $_POST['_waguru'] ) );
		}
		if ( ! isset( $_POST['_mail'] ) ) {
	    	$akademiguru['_mail'] = sanitize_text_field(wp_unslash( $_POST['_mail'] ) );
		} else {
	        $akademiguru['_mail'] = sanitize_text_field(wp_unslash( $_POST['_mail'] ) );
		}
		if ( ! isset( $_POST['_akademifb'] ) ) {
	    	$akademiguru['_akademifb'] = sanitize_text_field(wp_unslash( $_POST['_akademifb'] ) );
		} else {
	        $akademiguru['_akademifb'] = sanitize_text_field(wp_unslash( $_POST['_akademifb'] ) );
		}
		if ( ! isset( $_POST['_akademitw'] ) ) {
	    	$akademiguru['_akademitw'] = sanitize_text_field(wp_unslash( $_POST['_akademitw'] ) );
		} else {
	        $akademiguru['_akademitw'] = sanitize_text_field(wp_unslash( $_POST['_akademitw'] ) );
		}
		if ( ! isset( $_POST['_akademiig'] ) ) {
	    	$akademiguru['_akademiig'] = sanitize_text_field(wp_unslash( $_POST['_akademiig'] ) );
		} else {
	        $akademiguru['_akademiig'] = sanitize_text_field(wp_unslash( $_POST['_akademiig'] ) );
		}
		
	    foreach ($akademiguru as $key => $value) {        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); // 
	    }
	}
	add_action('save_post', 'guru_data_meta', 1, 2); 
	
	// Start Education
	
	add_action('admin_init', 'guru_education', 1);
	function guru_education() {
    	add_meta_box( 'education', 'Riwayat Pendidikan', 'edu_input', 'dosen', 'normal', 'default');
    }
	function edu_input() {
    	global $post;
    	$edu_guru = get_post_meta($post->ID, 'edu_guru', true);
    	wp_nonce_field( 'edu_gurumeta', 'edu_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-edu' ).on('click', function() {
			var row = $( '.emptyedu.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyedu screen-reader-text' );
			row.insertBefore( '#eduinkonten tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-edu' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
        
		<div class="sekolah_metabox">
        	<table id="eduinkonten">
		    
		    	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo  'Pendidikan'; ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo  'Tahun'; ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $edu_guru ) :
			foreach ( $edu_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduname[]" value="<?php if($field['eduname'] != '') echo esc_attr( $field['eduname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduyear[]" value="<?php if ($field['eduyear'] != '') echo esc_attr( $field['eduyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyedu screen-reader-text">
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
		    </table>
		</div>
		
		<div class="sekolah_metabox"><a id="add-edu" class="button button-primary button-large" href="#"><?php echo  'Tambah Baru'; ?></a></div> 
			
	<?php
    }
	add_action('save_post', 'edu_metasave');
	function edu_metasave($post_id) {
    	if ( ! isset( $_POST['edu_gurumeta'] ) ||
        	! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['edu_gurumeta'] ) ), 'edu_gurumeta' ) )
	    	return;
	    
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'edu_guru', true);
    	$news = array();
	    $edunames = wp_unslash( $_POST['eduname'] );
		$eduyears = wp_unslash( $_POST['eduyear'] );
	
    	if (is_array($edunames)) {
			$counts = count( $edunames );
		}
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $edunames[$i] != '' ) {
	    		$news[$i]['eduname'] = stripslashes( strip_tags( $edunames[$i] ) );
				$news[$i]['eduyear'] = stripslashes( strip_tags( $eduyears[$i] ) ); 
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'edu_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'edu_guru', $olds );
	}	
    
	// End Education
	
	// Start Work History
	
	add_action('admin_init', 'guru_history', 1);
	
	function guru_history() {
    	add_meta_box( 'historial', 'Riwayat Pekerjaan', 'his_input', 'dosen', 'normal', 'default');
    }
	function his_input() {
    	global $post;
    	$his_guru = get_post_meta($post->ID, 'his_guru', true);
    	wp_nonce_field( 'his_gurumeta', 'his_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-his' ).on('click', function() {
			var row = $( '.emptyhis.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyhis screen-reader-text' );
			row.insertBefore( '#hisinkonten tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-his' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
  
    	<div class="sekolah_metabox">
    		<table id="hisinkonten">
		    
		    	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo  'Pekerjaan'; ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo  'Tahun Kerja'; ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $his_guru ) :
			foreach ( $his_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisname[]" value="<?php if($field['hisname'] != '') echo esc_attr( $field['hisname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisyear[]" value="<?php if ($field['hisyear'] != '') echo esc_attr( $field['hisyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyhis screen-reader-text">
            		<td>
					    <div class="clear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo  'Hapus'; ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
	    	</table>
		</div>
		
		<div class="sekolah_metabox"><a id="add-his" class="button button-primary button-large" href="#"><?php echo  'Tambah Baru'; ?></a></div> 
			
	<?php
    }
	add_action('save_post', 'his_metasave');
	function his_metasave($post_id) {
    	if ( ! isset( $_POST['his_gurumeta'] ) ||
        	! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['his_gurumeta'] ) ), 'his_gurumeta' ) )
	    	return;
	
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'his_guru', true);
    	$news = array();
	
    	$hisnames = wp_unslash( $_POST['hisname'] );
		$hisyears = wp_unslash( $_POST['hisyear'] );
	
    	$counts = count( $hisnames );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $hisnames[$i] != '' ) {
	    		$news[$i]['hisname'] = stripslashes( strip_tags( $hisnames[$i] ) );
				$news[$i]['hisyear'] = stripslashes( strip_tags( $hisyears[$i] ) ); 
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'his_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'his_guru', $olds );
	}	
    
	// End Work History
	
?>