<?php
    
	
	
	register_post_type( 'download',		
	array(			
	    'menu_icon' => 'dashicons-arrow-down-alt2',
	    'labels'          => array(				
	    'name'                => 'Download',				
	    'singular_name'       => 'Download',        
	    'add_new'             => 'Tambah Download?',	
	    'add_new_item'        => 'Tambah Download',	
	    'edit'                => 'Edit',	 
	    'edit_item'           => 'Edit Download',	
	    'new_item'            => 'Item Baru',	
	    'view'                => 'Lihat Download',	
	    'view_item'           => 'Lihat Item',	
	    'search_items'        => 'Cari Item',	
	    'not_found'           => 'Tidak ada Download ditemukan',	
	    'not_found_in_trash'  => 'Tidak ada Download di folder Trash',	
	    'parent'              => 'Parent Super Duper',	
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
		 )	
    );
	
	add_action('admin_init', 'download_tutorial', 1);
	 
	function download_tutorial() {
	    add_meta_box('downloadtutorial', 'Tutorial Pengelolaan Pos Download', 'downloadtutorial', 'download', 'normal', 'default');
	}

	function downloadtutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://ciuss.com/tuts-download/' ); ?>
		</div>
    
	<?php }
	
add_action('admin_init', 'add_upload_file_metaboxes', 1);
function add_upload_file_metaboxes() {
    add_meta_box('swp_file_upload', 'File Upload', 'swp_file_upload', 'download', 'normal', 'default');
}
function swp_file_upload() {
    global $post;
    // Noncename needed to verify where the data originated
    echo '<input type="hidden" name="podcastmeta_noncename" id="podcastmeta_noncename" value="'.esc_attr(
    wp_create_nonce(plugin_basename(__FILE__))).
    '" />';
    global $wpdb;
    $strFile = get_post_meta($post -> ID, $key = 'podcast_file', true);
	$sizeFile = get_post_meta($post -> ID, $key = 'size_file', true);
    $media_file = get_post_meta($post -> ID, $key = '_wp_attached_file', true);
    if (!empty($media_file)) {
        $strFile = $media_file;
    } ?>
    <script type = "text/javascript">
        // Uploading files
        var file_frame;
        jQuery('#swp_file_upload').on('click', '#upload_image_button', function(podcast) {
        podcast.preventDefault();
        // If the media frame already exists, reopen it.
        if (file_frame) {
            file_frame.open();
            return;
        }
        // Create the media frame.
        file_frame = wp.media.frames.file_frame = wp.media({
            title: jQuery(this).data('uploader_title'),
            button: {
                text: jQuery(this).data('uploader_button_text'),
            },
            multiple: false // Set to true to allow multiple files to be selected
        });
        // When a file is selected, run a callback.
        file_frame.on('select', function(){
            // We set multiple to false so only get one image from the uploader
            attachment = file_frame.state().get('selection').first().toJSON();
            // here are some of the variables you could use for the attachment;
            var all = JSON.stringify( attachment );      
            var url = attachment.url;
            var filesizeHumanReadable = attachment.filesizeHumanReadable;
            var namefile = document.getElementById("podcast_file");
			var sizefile = document.getElementById("size_file");
            namefile.value = url; 
			sizefile.value = filesizeHumanReadable; 
        });
        // Finally, open the modal
        file_frame.open();
    });
    </script>
    
	<div class="sekolah_metabox">
	
	    <label><?php echo  'Unggah file melalui form di bawah ini atau pilih file dari Pustaka Media / Media Library'; ?></label>
	    <div class="sekolah_hidden">
		    <input type="text" name="podcast_file" placeholder="<?php echo 'tekan tombol upload dibawah...'; ?>" id="podcast_file" value="<?php echo esc_attr( $strFile ); ?>" class="widefat" />
	    </div>
		<input type="hidden" name="size_file" id="size_file" value="<?php echo esc_attr( $sizeFile); ?>" class="widefat" />
	
	</div>
	<div class="sekolah_metabox">
	    <br/>
	    <input id ="upload_image_button" type="button" value="<?php echo 'Upload'; ?>" class="button button-primary button-large" />
	</div>
    
	<?php
}
//Saving the file
function save_podcasts_meta($post_id, $post) {
    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
	if ( ! isset( $_POST['podcastmeta_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['podcastmeta_noncename'] )), plugin_basename(__FILE__) )) {
	    return $post -> ID;
    }
    // Is the user allowed to edit the post?
    if (!current_user_can('edit_post', $post -> ID))
        return $post -> ID;
    // We need to find and save the data
    // We'll put it into an array to make it easier to loop though.
	if ( ! isset( $_POST['podcast_file'] ) ) {
        $podcasts_meta['podcast_file'] = sanitize_text_field( wp_unslash( $_POST['podcast_file'] ));
	} else {
		$podcasts_meta['podcast_file'] = sanitize_text_field( wp_unslash( $_POST['podcast_file'] ));
	}
	if ( ! isset( $_POST['size_file'] ) ) {
    	$podcasts_meta['size_file'] = sanitize_text_field( wp_unslash( $_POST['size_file'] ));
	} else {
	    $podcasts_meta['size_file'] = sanitize_text_field( wp_unslash( $_POST['size_file'] ));
	}
    // Add values of $podcasts_meta as custom fields
    foreach($podcasts_meta as $key => $value) {
        if ($post -> post_type == 'revision') return;
        $value = implode(',', (array) $value);
        if (get_post_meta($post -> ID, $key, FALSE)) { // If the custom field already has a value it will update
            update_post_meta($post -> ID, $key, $value);
        } else { // If the custom field doesn't have a value it will add
            add_post_meta($post -> ID, $key, $value);
        }
        if (!$value) delete_post_meta($post -> ID, $key); // Delete if blank value
    }
}
add_action('save_post', 'save_podcasts_meta', 1, 2); // save the custom fields
	
?>