<?php
    
	
	
	register_post_type( 'siswa',		
	array(			
	    'menu_icon' => 'dashicons-buddicons-buddyakademi-logo',
	    'labels'          => array(				
	    'name'                => 'Siswa',				
	    'singular_name'       => 'Siswa',        
	    'add_new'             => 'Tambah Siswa?',	
	    'add_new_item'        => 'Tambah Siswa',	
	    'edit'                => 'Edit',	 
	    'edit_item'           => 'Edit Siswa',	
	    'new_item'            => 'Item Baru',	
	    'view'                => 'Lihat Siswa',	
	    'view_item'           => 'Lihat Item',	
	    'search_items'        => 'Cari Item',	
	    'not_found'           => 'Tidak ada Siswa ditemukan',	
	    'not_found_in_trash'  => 'Tidak ada Siswa di folder Trash',	
	    'parent'              => 'Parent Super Duper',
        'featured_image'      => 'Pas Photo 300 x 400',		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
		 )	
    );
	
	add_action('admin_init', 'siswa_tutorial', 1);
	 
	function siswa_tutorial() {
	    add_meta_box('siswatutorial', 'Tutorial Pengelolaan Pos Siswa', 'siswatutorial', 'siswa', 'normal', 'default');
	}

	function siswatutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://ciuss.com/tuts-siswa/' ); ?>
		</div>
    
	<?php }
	
	add_action('admin_init', 'sis_meta', 1);
	function sis_meta() {
	    add_meta_box('sis_data', 'Diodata Siswa', 'sis_data', 'siswa', 'normal', 'default');
	}
	function sis_data() {
	    global $post;
	    echo '<input type="hidden" name="siswa_noncename" id="siswa_noncename" value="' .esc_attr(
	    wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';
	    $mas = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="sekolah_metabox">
		
		    <label><?php echo 'Mulai masuk sekolah'; ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo 'NISN'; ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo 'Jenis Kelamin'; ?></label>
	        <input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo 'Tempat Lahir'; ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo 'Tanggal Lahir'; ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo 'Agama'; ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo 'Alamat'; ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo 'Telpon'; ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo 'Email'; ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo 'Anak ke'; ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo 'dari berapa bersaudara?'; ?></label>
	                    <input type="text" name="_dari" value="<?php echo esc_attr( $dari ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo 'Nama Ayah'; ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo 'Nama Ibu'; ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <label><?php echo 'Alamat Orang Tua'; ?></label>
	        <input type="date" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function sis_data_meta($post_id, $post) {
	    if ( !isset( $_POST['siswa_noncename'] ) || !wp_verify_nonce( $_POST['siswa_noncename'], plugin_basename(__FILE__) )) {
            return $post->ID;
        }
	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
	    $santri['_mas'] = sanitize_text_field( $_POST['_mas'] );
		$santri['_nisn'] = sanitize_text_field( $_POST['_nisn'] );
		$santri['_sex'] = sanitize_text_field( $_POST['_sex'] );
		$santri['_tmpt'] = sanitize_text_field( $_POST['_tmpt'] );
		$santri['_tgl'] = sanitize_text_field( $_POST['_tgl'] );
		$santri['_rel'] = sanitize_text_field( $_POST['_rel'] );
		$santri['_add'] = sanitize_text_field( $_POST['_add'] );
		$santri['_telp'] = sanitize_text_field( $_POST['_telp'] );
		$santri['_mail'] = sanitize_text_field( $_POST['_mail'] );
		$santri['_anak'] = sanitize_text_field( $_POST['_anak'] );
		$santri['_dari'] = sanitize_text_field( $_POST['_dari'] );
		$santri['_ayah'] = sanitize_text_field( $_POST['_ayah'] );
		$santri['_ibu'] = sanitize_text_field( $_POST['_ibu'] );
		
	    foreach ($santri as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }
	}
	add_action('save_post', 'sis_data_meta', 1, 2); 
	
?>