<?php
function sekolah_wp_customize_register( $wp_customize ) {
	$color_scheme = sekolah_get_color_scheme();
    
	// Add color scheme setting and control.
	$wp_customize->add_setting(
		'color_scheme',
		array(
			'default'           => 'default',
			'sanitize_callback' => 'sekolah_sanitize_color_scheme',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		'color_scheme',
		array(
			'label'    => 'Pilihan Warna Tema',
			'section'  => 'colors',
			'type'     => 'select',
			'choices'  => sekolah_get_color_scheme_choices(),
			'priority' => 1,
		)
	);
	// Add page background color setting and control.
	$wp_customize->add_setting(
		'sekolah_color1',
		array(
			'default'           => $color_scheme[1],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color1',
			array(
				'label'   => 'BG Wrapper',
				'section' => 'colors',
			)
		)
	);
	// Remove the core header sekolah_color3 control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );
	// Add link color setting and control.
	$wp_customize->add_setting(
		'sekolah_color2',
		array(
			'default'           => $color_scheme[2],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color2',
			array(
				'label'   => 'Text Color',
				'section' => 'colors',
			)
		)
	);
	// Add main text color setting and control.
	$wp_customize->add_setting(
		'sekolah_color3',
		array(
			'default'           => $color_scheme[3],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
    
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color3',
			array(
				'label'   => 'Link Color',
				'section' => 'colors',
			)
		)
	);
	// Running Text.
	$wp_customize->add_setting(
		'sekolah_color4',
		array(
			'default'           => $color_scheme[4],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color4',
			array(
			    'label'             => 'Sekolah Menu',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color5',
		array(
			'default'           => $color_scheme[5],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color5',
			array(
				'description'   => 'Aksen Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color6',
		array(
			'default'           => $color_scheme[6],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color6',
			array(
				'description'   => 'Link Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color7',
		array(
			'default'           => $color_scheme[7],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color7',
			array(
				'label'   => 'Running Text',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color8',
		array(
			'default'           => $color_scheme[8],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color8',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color9',
		array(
			'default'           => $color_scheme[9],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color9',
			array(
				'label'   => 'Header',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color10',
		array(
			'default'           => $color_scheme[10],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color10',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color11',
		array(
			'default'           => $color_scheme[11],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color11',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
	// Phone Header
	$wp_customize->add_setting(
		'sekolah_color12',
		array(
			'default'           => $color_scheme[12],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color12',
			array(
				'label'   => 'Sosial Ikon',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color13',
		array(
			'default'           => $color_scheme[13],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color13',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color14',
		array(
			'default'           => $color_scheme[14],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color14',
			array(
				'label'   => 'Nama Sekolah',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color15',
		array(
			'default'           => $color_scheme[15],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color15',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color16',
		array(
			'default'           => $color_scheme[16],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color16',
			array(
				'label'   => 'Editorial News',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color17',
		array(
			'default'           => $color_scheme[17],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color17',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	// inkonten Home
	$wp_customize->add_setting(
		'sekolah_color18',
		array(
			'default'           => $color_scheme[18],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color18',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color19',
		array(
			'default'           => $color_scheme[19],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color19',
			array(
				'label'   => 'Home Quotes',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color20',
		array(
			'default'           => $color_scheme[20],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color20',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	// Produk
	$wp_customize->add_setting(
		'sekolah_color21',
		array(
			'default'           => $color_scheme[21],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color21',
			array(
				'label'   => 'Home GTK',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color22',
		array(
			'default'           => $color_scheme[22],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color22',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color23',
		array(
			'default'           => $color_scheme[23],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color23',
			array(
				'label'   => 'Pengumuman, Agenda, Blog',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color24',
		array(
			'default'           => $color_scheme[24],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color24',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	// Agen
	$wp_customize->add_setting(
		'sekolah_color25',
		array(
			'default'           => $color_scheme[25],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color25',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color26',
		array(
			'default'           => $color_scheme[26],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color26',
			array(
				'label'   => 'Ekskul, Fasilitas, Galeri',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color27',
		array(
			'default'           => $color_scheme[27],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color27',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color28',
		array(
			'default'           => $color_scheme[28],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color28',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color29',
		array(
			'default'           => $color_scheme[29],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color29',
			array(
				'label'   => 'Video Home',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color30',
		array(
			'default'           => $color_scheme[30],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color30',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	// Label Kendaraan
	$wp_customize->add_setting(
		'sekolah_color31',
		array(
			'default'           => $color_scheme[31],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color31',
			array(
				'label'   => 'Widget Footer',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color32',
		array(
			'default'           => $color_scheme[32],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color32',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color33',
		array(
			'default'           => $color_scheme[33],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color33',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color34',
		array(
			'default'           => $color_scheme[34],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color34',
			array(
				'label'   => 'Footer',
				'description'   => 'BG Color',
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'sekolah_color35',
		array(
			'default'           => $color_scheme[35],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color35',
			array(
				'description'   => 'Color',
				'section' => 'colors',
			)
		)
	);
	// Parallax
	$wp_customize->add_setting(
		'sekolah_color36',
		array(
			'default'           => $color_scheme[36],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekolah_color36',
			array(
				'description'   => 'Link',
				'section' => 'colors',
			)
		)
	);
}
add_action( 'customize_register', 'sekolah_wp_customize_register', 11 );
if ( ! function_exists( 'sekolah_get_color_scheme' ) ) :
	
	function sekolah_get_color_scheme() {
		$color_scheme_option = get_theme_mod( 'color_scheme', 'default' );
		$color_schemes       = sekolah_get_color_schemes();
		if ( array_key_exists( $color_scheme_option, $color_schemes ) ) {
			return $color_schemes[ $color_scheme_option ]['colors'];
		}
		return $color_schemes['default']['colors'];
	}
endif; 
if ( ! function_exists( 'sekolah_get_color_scheme_choices' ) ) :
	
	function sekolah_get_color_scheme_choices() {
		$color_schemes                = sekolah_get_color_schemes();
		$color_scheme_control_options = array();
		foreach ( $color_schemes as $color_scheme => $value ) {
			$color_scheme_control_options[ $color_scheme ] = $value['label'];
		}
		return $color_scheme_control_options;
	}
endif; 
if ( ! function_exists( 'sekolah_sanitize_color_scheme' ) ) :
	
	function sekolah_sanitize_color_scheme( $value ) {
		$color_schemes = sekolah_get_color_scheme_choices();
		if ( ! array_key_exists( $value, $color_schemes ) ) {
			$value = 'default';
		}
		return $value;
	}
endif; 