<?php
/**
 * Customizer WP Sekolah
 * Setting tema dari menu Customizer
 */
function sekolah_customize_register( $wp_customize ) {
	
$wp_customize->add_panel('sekolah_profile',array(
    'title'       => 'Sekolah : Pengaturan',
    'description' => 'Pengaturan Tema WP Sekolah',
    'priority'    => 40,
));
$wp_customize->add_section('sekolah_editor',array(
    'title'       => 'Pilihan Editor',
    'description' => 'WordPress memiliki 2 jenis editor untuk menulis konten, editor yang terkini bernama Gutenberg (editor berbentuk block builder) yang terkadang membuat loading agak berat, editor yang kedua adalah editor versi lama atau disebut Classic Editor yang jauh lebih ringan dan familiar dari segi kemudahan. <br/><br/>Opsi ini tidak berlaku untuk <strong>Pos</strong> dan <strong>Laman</strong>, hanya untuk pos bawaan tema (Agenda, Pengumuman, dll...)',
    'priority'    => 5,
    'panel'       => 'sekolah_profile',
));
// Nama Usaha
$wp_customize->add_setting('opsi_editor',array(
    'default'     => 'true',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('opsi_editor',array(
    'label'        => 'Pilih Editor',
	'description'  => 'Pilihan Editor untuk menulis',
    'type'         => 'select',
	'choices'     => array(
		'true'      => 'Gutenberg (Editor Block)',
		'false'     => 'Classic Editor (Mode WYSIWYG)',
	),
    'section'      => 'sekolah_editor',
    'settings'     => 'opsi_editor',
));
$wp_customize->add_section('profile_sekolah',array(
    'title'       => 'Profile Sekolah',
    'description' => 'Lengkapi data profile sekolah',
    'priority'    => 20,
    'panel'       => 'sekolah_profile',
));
// Nama Usaha
$wp_customize->add_setting('sekolah_type',array(
    'default'     => 'sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('sekolah_type',array(
    'label'        => 'Kategori Sekolah',
	'description'  => 'PENTING : Setiap kali memilih kategori sekolah, selanjutnya WAJIB untuk melakukan <a target="_blank" href="'. admin_url( 'options-permalink.php', 'https' ) .'">Update Permalink</a> supaya fitur sesuai kategori sekolah berjalan dengan baik dan tidak muncul 404',
    'type'         => 'select',
	'choices'     => array(
		'sekolah'      => 'Umum, Madrasah, Kejuruan',
		'pesantren'    => 'Pesantren',
		'akademi'      => 'Sekolah Tinggi',
	),
    'section'      => 'profile_sekolah',
    'settings'     => 'sekolah_type',
));
$wp_customize->add_setting('nama_sekolah',array(
    'default'     => 'SMA Negeri 1 Comal',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('nama_sekolah',array(
    'label'        => 'Nama Sekolah',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'nama_sekolah',
));
$wp_customize->add_setting('kepala_sekolah',array(
    'default'     => 'Yayun Ciuss',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('kepala_sekolah',array(
    'label'        => 'Nama Pimpinan',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'kepala_sekolah',
));
// Foto Kepala
$wp_customize->add_setting( 'foto_kepala', array(
    'default' => get_theme_file_uri('gambar/photo.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'foto_kepala', array(
    'label'         => 'Foto Pimpinan',
	'description'   => 'Upload foto mode pas photo (300x400 pixel)',
    'section'       => 'profile_sekolah',
    'settings'      => 'foto_kepala',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// NSPN
$wp_customize->add_setting('nspn_data',array(
    'default'     => '20404xxx',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('nspn_data',array(
    'label'        => 'NSPN',
	'description'  => 'Nomer Pokok Sekolah Nasional',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'nspn_data',
));
// Alamat
$wp_customize->add_setting('address_data',array(
    'default'     => 'Jl Jend A Yani no. 77 Comal, Pemalang, Jawa Tengah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('address_data',array(
    'label'        => 'Alamat',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'address_data',
));
// Nomer Telepon
$wp_customize->add_setting('telpon_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('telpon_data',array(
    'label'        => 'Nomer Telpon',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'telpon_data',
));
// Alamat Email
$wp_customize->add_setting('email_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'sanitize_email'
));
$wp_customize->add_control('email_data',array(
    'label'        => 'Alamat Email',
    'type'         => 'email',
    'section'      => 'profile_sekolah',
    'settings'     => 'email_data',
));
// WhatsApp
$wp_customize->add_setting('wa_data',array(
    'default'     => '+62-81532744804',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('wa_data',array(
    'label'        => 'WhatsApp',
	'description'  => 'awali dengan 62 bukan 0',
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'wa_data',
));
// Facebook
$wp_customize->add_setting('facebook_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('facebook_data',array(
    'label'        => 'Facebook',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'facebook_data',
	'input_attrs' => array(
        'placeholder' => 'https://...',
    )
));
// Twitter
$wp_customize->add_setting('twitter_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('twitter_data',array(
    'label'        => 'Twitter',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'twitter_data',
	'input_attrs' => array(
        'placeholder' => 'https://...',
    )
));
// Instagram
$wp_customize->add_setting('instagram_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('instagram_data',array(
    'label'       => 'Instagram',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'instagram_data',
	'input_attrs' => array(
        'placeholder' => 'https://...',
    )
));
// Youtube
$wp_customize->add_setting('youtube_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('youtube_data',array(
    'label'       => 'Youtube',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'youtube_data',
	'input_attrs' => array(
        'placeholder' => 'https://...',
    )
));
	
$wp_customize->add_section('sekolah_runing',array(
    'title'       => 'Running Text',
    'description' => 'Tambahkan konten untuk runing text, tag HTML diperbolehkan tetapi harap minimalkan agar tidak merusak tampilan, gunakan hanya<br/> &lt;strong&gt;<strong>huruf tebal</strong>&lt;/strong&gt;<br/>&lt;em&gt;<em>huruf miring</em>&lt;/em&gt;<br/>&lt;a href="https://.."&gt;<a href="#">link / tautan</a>&lt;/a&gt; <br/>Gunakan shortcode [spasi] untuk memisahkan info ',
    'priority'    => 35,
    'panel'       => 'sekolah_profile',
));
// Run
$wp_customize->add_setting('running_text',array(
    'default'     => 'Tema sekolah dapat menampilkan informasi dalam text berjalan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('running_text',array(
    'label'        => 'Isi running text',
    'type'         => 'textarea',
    'section'      => 'sekolah_runing',
    'settings'     => 'running_text',
));
	
$wp_customize->add_section('replace_text',array(
    'title'       => 'Replace Text',
    'description' => 'Gunakan untuk mengganti beberapa text default bawaan tema',
    'priority'    => 25,
    'panel'       => 'sekolah_profile',
));
$wp_customize->add_setting('re_kepsek',array(
    'default'     => 'Kepala Sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_kepsek',array(
    'label'        => 'Kepala Sekolah',
	'description'  => 'Lokasi pada foto kepala sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_kepsek',
));
$wp_customize->add_setting('re_editorial',array(
    'default'     => 'Editorial',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_editorial',array(
    'label'        => 'Editorial',
	'description'  => 'Lokasi pada Editorial kepala sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_editorial',
));
$wp_customize->add_setting('re_editormore',array(
    'default'     => 'Selengkapnya',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_editormore',array(
    'label'        => 'Lihat Semua',
	'description'  => 'Lokasi pada Editorial kepala sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_editormore',
));
$wp_customize->add_setting('re_news',array(
    'default'     => 'Berita Terbaru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_news',array(
    'label'        => 'Berita Terbaru',
	'description'  => 'Lokasi di daftar artikel terbaru di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_news',
));
$wp_customize->add_setting('re_quotes',array(
    'default'     => 'Kata Bijak',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_quotes',array(
    'label'        => 'Kata Bijak',
	'description'  => 'Lokasi pada blok Quotes di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_quotes',
));
$wp_customize->add_setting('re_gurus',array(
    'default'     => 'Guru-Guru Keren',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_gurus',array(
    'label'        => 'Guru-Guru Keren',
	'description'  => 'Lokasi pada blok GTK di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_gurus',
));
$wp_customize->add_setting('re_pengumuman',array(
    'default'     => 'Pengumuman',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_pengumuman',array(
    'label'        => 'Pengumuman',
	'description'  => 'Lokasi pada blok Pengumuman di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_pengumuman',
));
$wp_customize->add_setting('re_agenda',array(
    'default'     => 'Agenda Terbaru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_agenda',array(
    'label'        => 'Agenda Terbaru',
	'description'  => 'Lokasi pada blok Agenda di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_agenda',
));
$wp_customize->add_setting('re_blog',array(
    'default'     => 'Blog Guru',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_blog',array(
    'label'        => 'Blog Guru',
	'description'  => 'Lokasi pada Blog Guru di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_blog',
));
$wp_customize->add_setting('re_kegiatan',array(
    'default'     => 'Kegiatan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_kegiatan',array(
    'label'        => 'Kegiatan',
	'description'  => 'Lokasi pada Kegiatan sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_kegiatan',
));
$wp_customize->add_setting('re_fasilitas',array(
    'default'     => 'Fasilitas',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_fasilitas',array(
    'label'        => 'Fasilitas',
	'description'  => 'Lokasi pada Fasilitas sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_fasilitas',
));
$wp_customize->add_setting('re_galeri',array(
    'default'     => 'Galeri',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_galeri',array(
    'label'        => 'Galeri',
	'description'  => 'Lokasi pada Galeri sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_galeri',
));
$wp_customize->add_setting('re_video',array(
    'default'     => 'Video',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_video',array(
    'label'        => 'Video',
	'description'  => 'Lokasi pada Video sekolah di Beranda',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_video',
));
// 404
$wp_customize->add_setting('re_head',array(
    'default'     => '404, Halaman tidak ditemukan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_head',array(
    'label'        => 'Judul 404',
	'description'  => 'Lokasi di halaman 404',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_head',
));
$wp_customize->add_setting('re_text',array(
    'default'     => 'Halaman ini tidak tersedia atau mungkin sudah kadaluarsa',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_text',array(
    'label'        => 'Text 404',
	'description'  => 'Lokasi di halaman 404',
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_text',
));
// Footer
$wp_customize->add_setting('copy_foot',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('copy_foot',array(
    'label'        => 'Footer Copyright',
	'description'  => 'Mengganti text copyright pada footer website',
    'type'         => 'textarea',
    'section'      => 'replace_text',
    'settings'     => 'copy_foot',
));
// Layout Setting
$wp_customize->add_section('sekolah_layout',array(
    'title'       => 'Layout Setting',
    'description' => 'Pengaturan terkait dengan tampilan konten bawaan tema',
    'priority'    => 15,
    'panel'       => 'sekolah_profile',
));

$wp_customize->add_setting('mode_layout',array(
    'default'     => 'old',
	'transport'   => 'refresh',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('mode_layout',array(
    'label'        => 'Pilih Layout',
	'description'  => 'Pilihan layout yang ingin digunakan (Akan segera rilis layout baru)',
    'type'         => 'select',
	'choices'     => array(
		'old'      => 'Default (Versi Lama)',
		//'class'    => 'Classroom',
	),
    'section'      => 'sekolah_layout',
    'settings'     => 'mode_layout',
));

// Foto Share
$wp_customize->add_setting( 'share_image', array(
    'default' => get_theme_file_uri('gambar/share.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'share_image', array(
    'label' => 'Gambar Default Share',
	'description' => 'Atur sebuah gambar yang akan menjadi gambar default jika link di-share ke Facebook, Twitter, dan WhatsApp',
    'section' => 'sekolah_layout',
    'settings' => 'share_image',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// Thumbnail
$wp_customize->add_setting( 'default_thumbnail', array(
    'default' => get_theme_file_uri('gambar/sekolah.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'default_thumbnail', array(
    'label' => 'Default Gambar Unggulan',
	'description' => 'Atur sebuah gambar yang akan menjadi gambar default jika tidak ada Gambar Unggulan',
    'section' => 'sekolah_layout',
    'settings' => 'default_thumbnail',
    'button_labels' => array(// All These labels are optional
                    'select' => 'Pilih Foto',
                    'remove' => 'Hapus Foto',
                    'change' => 'Ganti Foto',
                    )
)));
// Slide
$wp_customize->add_setting('slide_width',array(
    'default'     => 1200,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_width',array(
    'label'        => 'Ganti Ukuran Slider',
	'description' => 'PENTING : Setelah ukuran baru tersimpan. WAJIB melakukan <a target="_blank" href="'. esc_url('https://ciuss.com/regenerate') .'">Re-generate Thumbnail</a> agar ukuran baru tersebut bekerja ke semua gambar.',
    'type'         => 'number',
    'section'      => 'sekolah_layout',
    'settings'     => 'slide_width',
));
$wp_customize->add_setting('slide_height',array(
    'default'     => 600,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_height',array(
    'type'         => 'number',
    'section'      => 'sekolah_layout',
    'settings'     => 'slide_height',
));
$wp_customize->add_setting('slide_timer',array(
    'default'     => 6,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'theme_slug_sanitize_select'
));
$wp_customize->add_control('slide_timer',array(
    'label'        => 'Durasi Pergantian Slide',
	'description'  => 'Efek perubahan bisa dilihat pada Slide ke halaman Beranda',
    'type'         => 'select',
	'choices'     => array(
		'3'      => '3 Detik',
		'4'      => '4 Detik',
		'5'      => '5 Detik',
		'6'      => '6 Detik',
		'7'      => '7 Detik',
		'8'      => '8 Detik',
		'9'      => '9 Detik',
		'10'     => '10 Detik',
	),
    'section'      => 'sekolah_layout',
    'settings'     => 'slide_timer',
));
// WhatsApp Section
$wp_customize->add_section('wa_section',array(
    'title'       => 'Setting WhatsApp',
    'description' => 'Gunakan untuk mengganti text pesan WhatsApp bawaan tema',
    'priority'    => 80,
    'panel'       => 'sekolah_profile',
));
$wp_customize->add_setting('chat_sekolah',array(
    'default'     => 'Saya ingin informasi seputar sekolah...',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('chat_sekolah',array(
    'label'        => 'Pesan Umum',
	'description'  => 'Ubah pesan default tombol WhatsApp utama',
    'type'         => 'text',
    'section'      => 'wa_section',
    'settings'     => 'chat_sekolah',
));

// Tema Premium
$wp_customize->add_section('ciuss_premium',array(
    'title'       => 'Tema Premium',
    'priority'    => 10,
    'panel'       => 'sekolah_profile',
));
$wp_customize->add_setting('tema_premium',array(
    'default'     => 'Saya ingin informasi seputar sekolah...',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('tema_premium',array(
	'description'  => '<div class="premium">Dapatkan tema sekolah dengan tampilan yang lebih keren dari Ciuss Creative. Cek bedanya <strong>Mading</strong> dengan <strong>WP Sekolah</strong> <a href="'.esc_url( 'https://ciuss.com/compare' ).'">disini</a></div>
	                <a class="premium_link" target="_blank" href="'.esc_url( 'https://ciuss.com/tema-wordpress/mading' ).'">
						<img src="'.esc_url( get_template_directory_uri().'/gambar/4.2.jpg' ).'" />
						</a>',
    'type'         => 'hidden',
    'section'      => 'ciuss_premium',
    'settings'     => 'tema_premium',
));

}
add_action( 'customize_register', 'sekolah_customize_register', 11 );