<?php
    
	
	
	register_post_type( 'mahasiswa',		
	array(			
	    'menu_icon' => 'dashicons-buddicons-buddyakademi-logo',
	    'labels'          => array(				
	    'name'                => 'Mahasiswa',				
	    'singular_name'       => 'Mahasiswa',        
	    'add_new'             => 'Tambah Mahasiswa?',	
	    'add_new_item'        => 'Tambah Mahasiswa',	
	    'edit'                => 'Edit',	 
	    'edit_item'           => 'Edit Mahasiswa',	
	    'new_item'            => 'Item Baru',	
	    'view'                => 'Lihat Mahasiswa',	
	    'view_item'           => 'Lihat Item',	
	    'search_items'        => 'Cari Item',	
	    'not_found'           => 'Tidak ada Mahasiswa ditemukan',	
	    'not_found_in_trash'  => 'Tidak ada Mahasiswa di folder Trash',	
	    'parent'              => 'Parent Super Duper',
        'featured_image'      => 'Pas Photo 300 x 400',		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
		 )	
    );
	
	add_action('admin_init', 'mahasiswa_tutorial', 1);
	 
	function mahasiswa_tutorial() {
	    add_meta_box('mahasiswatutorial', 'Tutorial Pengelolaan Pos Mahasiswa', 'mahasiswatutorial', 'mahasiswa', 'normal', 'default');
	}

	function mahasiswatutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://ciuss.com/tuts-siswa/' ); ?>
		</div>
    
	<?php }
	
	add_action('admin_init', 'mhs', 1);
	function mhs() {
	    add_meta_box('mhs_data', 'Diodata Mahasiswa', 'mhs_data', 'mahasiswa', 'normal', 'default');
	}
	function mhs_data() {
	    global $post;
	    echo '<input type="hidden" name="eventmeta_noncename" id="eventmeta_noncename" value="' .esc_attr(
	    wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';
	    $mas = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl = get_post_meta($post->ID, '_tgl', true);
		$rel = get_post_meta($post->ID, '_rel', true);
		$add = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="sekolah_metabox">
		
		    <label><?php echo  'Mulai masuk kampus'; ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo  'NIM'; ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo  'Jenis Kelamin'; ?></label>
	        <input type="text" name="_sex" value="<?php echo esc_attr( $sex ); ?>" class="widefat" />
			
			<label><?php echo  'Tempat Lahir'; ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo  'Tanggal Lahir'; ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo  'Agama'; ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo  'Alamat'; ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo  'Telpon'; ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo  'Email'; ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo  'Anak ke'; ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo  'dari berapa bersaudara?'; ?></label>
	                    <input type="text" name="_dari" value="<?php echo esc_attr( $dari ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="clear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo  'Nama Ayah'; ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo  'Nama Ibu'; ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <label><?php echo  'Alamat Orang Tua'; ?></label>
	        <input type="date" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			
		</div>
			
	<?php }
	
	function mhs_data_meta($post_id, $post) {
	    if ( !isset( $_POST['eventmeta_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['eventmeta_noncename'])), plugin_basename(__FILE__) )) {
            return $post->ID;
        }
	    if ( !current_user_can( 'edit_post', $post->ID ))
	        return $post->ID;
		if ( ! isset( $_POST['_mas'] ) ) {
	        $mahasiswa['_mas'] = sanitize_text_field( wp_unslash( $_POST['_mas'] ));
		} else {
	        $mahasiswa['_mas'] = sanitize_text_field( wp_unslash( $_POST['_mas'] ));
		}
		if ( ! isset( $_POST['_nisn'] ) ) {
	    	$mahasiswa['_nisn'] = sanitize_text_field( wp_unslash( $_POST['_nisn'] ));
		} else  {
	    	$mahasiswa['_nisn'] = sanitize_text_field( wp_unslash( $_POST['_nisn'] ));
		}
		if ( ! isset( $_POST['_sex'] ) ) {
	    	$mahasiswa['_sex'] = sanitize_text_field( wp_unslash( $_POST['_sex'] ));
		} else  {
	    	$mahasiswa['_sex'] = sanitize_text_field( wp_unslash( $_POST['_sex'] ));
		}
		if ( ! isset( $_POST['_tmpt'] ) ) {
	    	$mahasiswa['_tmpt'] = sanitize_text_field( wp_unslash( $_POST['_tmpt'] ));
		} else {
	    	$mahasiswa['_tmpt'] = sanitize_text_field( wp_unslash( $_POST['_tmpt'] ));
		}
		if ( ! isset( $_POST['_tgl'] ) ) {
	    	$mahasiswa['_tgl'] = sanitize_text_field( wp_unslash( $_POST['_tgl'] ));
		} else {
	    	$mahasiswa['_tgl'] = sanitize_text_field( wp_unslash( $_POST['_tgl'] ));
		}
		if ( ! isset( $_POST['_rel'] ) ) {
	    	$mahasiswa['_rel'] = sanitize_text_field( wp_unslash( $_POST['_rel'] ));
		} else {
	    	$mahasiswa['_rel'] = sanitize_text_field( wp_unslash( $_POST['_rel'] ));
		}
		if ( ! isset( $_POST['_add'] ) ) {
	    	$mahasiswa['_add'] = sanitize_text_field( wp_unslash( $_POST['_add'] ));
		} else  {
	    	$mahasiswa['_add'] = sanitize_text_field( wp_unslash( $_POST['_add'] ));
		}
		if ( ! isset( $_POST['_telp'] ) ) {
	    	$mahasiswa['_telp'] = sanitize_text_field( wp_unslash( $_POST['_telp'] ));
		} else  {
	    	$mahasiswa['_telp'] = sanitize_text_field( wp_unslash( $_POST['_telp']) );
		}
		if ( ! isset( $_POST['_mail'] ) ) {
	    	$mahasiswa['_mail'] = sanitize_text_field( wp_unslash( $_POST['_mail'] ));
		} else {
	    	$mahasiswa['_mail'] = sanitize_text_field( wp_unslash( $_POST['_mail'] ));
		}
		if ( ! isset( $_POST['_anak'] ) ) {
	    	$mahasiswa['_anak'] = sanitize_text_field( wp_unslash( $_POST['_anak'] ));
		} else  {
	    	$mahasiswa['_anak'] = sanitize_text_field( wp_unslash( $_POST['_anak'] ));
		}
		if ( ! isset( $_POST['_dari'] ) ) {
	    	$mahasiswa['_dari'] = sanitize_text_field( wp_unslash( $_POST['_dari'] ));
		} else {
	    	$mahasiswa['_dari'] = sanitize_text_field( wp_unslash( $_POST['_dari'] ));
		}
		if ( ! isset( $_POST['_ayah'] ) ) {
	    	$mahasiswa['_ayah'] = sanitize_text_field( wp_unslash( $_POST['_ayah'] ));
		} else {
			$mahasiswa['_ayah'] = sanitize_text_field( wp_unslash( $_POST['_ayah'] ));
		}
		if ( ! isset( $_POST['_ibu'] ) ) {
	    	$mahasiswa['_ibu'] = sanitize_text_field( wp_unslash( $_POST['_ibu'] ));
		} else {
	    	$mahasiswa['_ibu'] = sanitize_text_field( wp_unslash( $_POST['_ibu'] ));
		}
		
	    foreach ($mahasiswa as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post->ID, $key, FALSE)) { 
	            update_post_meta($post->ID, $key, $value);
	        } else { 
	            add_post_meta($post->ID, $key, $value);
	        }
	        if(!$value) delete_post_meta($post->ID, $key); 
	    }
	}
	add_action('save_post', 'mhs_data_meta', 1, 2); 
	
	add_action( 'init', 'mhs_fakultas', 0 );
	function mhs_fakultas() {
	    $labels = array(
    	    'name'              => 'Fakultas / Semester',
	        'singular_name'     => 'Fakultas / Semester',
	        'search_items'      => 'Cari..',
    	    'all_items'         => 'Semua Data',
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => 'Edit Data',
    	    'update_item'       => 'Update Data',
    	    'add_new_item'      => 'Tambah Baru',
    	    'new_item_name'     => 'Tambah Data Baru',
    	    'menu_name'         => 'Fakultas / Semester',
	    );   
	  
	    register_taxonomy('fakultas',array('mahasiswa'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
			'default_term'      => 'Ekonomi Sementer 4',
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
	  ));
	}