<?php
function additional_user_fields( $user ) { ?>
	    <h3><?php echo 'Tambah Foto Profile'; ?></h3>
		<?php wp_enqueue_media(); ?>
	
	    <script>
	    	jQuery(document).ready(function($){
			    var file_frame;
				$('.additional-user-image').on('click', function( event ){
				    event.preventDefault();
					
					if ( file_frame ) {
				    	file_frame.open();
						return;
					}
					
					file_frame = wp.media.frames.file_frame = wp.media({
					    title: $( this ).data( 'uploader_title' ),
						button: {
						text: $( this ).data( 'uploader_button_text' ),
					},
					multiple: false  
				});
				
				file_frame.on( 'select', function() {
			    	attachment = file_frame.state().get('selection').first().toJSON();
					jQuery(".foto").attr('value', attachment.url);
					jQuery('img.image-preview').attr('src', attachment.sizes.full.url);
				});
				
				file_frame.open();
			});
		});
	</script>
	
	<table id="upgrade" class="form-table">
        <tbody>
		<tr class="user-description-wrap">
			<th><label for="user_meta_image"><?php echo 'Photo Profile'; ?></label></th>
			<td>
				<img class="image-preview" src="<?php echo esc_url( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>" style="width:150px; margin: 0 20px 0 0; float: left;">
				<input type="hidden" name="user_meta_image" class="foto" id="user_meta_image" value="<?php echo esc_url_raw( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>" class="regular-text" />
				<input type='button' class="additional-user-image button-primary" value="<?php echo 'Unggah Photo'; ?>" id="uploadimage"/><br />
				<p class="description"><?php echo 'Tambahkan sebuah gambar untuk dijadikan sebagai gambar profile.'; ?></p>
			</td>
		</tr>
	</table>
	
<?php } 
    add_action( 'show_user_profile', 'additional_user_fields' );
    add_action( 'edit_user_profile', 'additional_user_fields' );
	
	function save_additional_user_meta( $user_id ) {
    	if ( !current_user_can( 'edit_user', $user_id ) )
	    	return false;
		update_user_meta( $user_id, 'user_meta_image', $_POST['user_meta_image'] );
	}
	add_action( 'personal_options_update', 'save_additional_user_meta' );
	add_action( 'edit_user_profile_update', 'save_additional_user_meta' );
	
	function get_attachment_image_by_url( $url ) {
    	$parse_url  = explode( parse_url( WP_CONTENT_URL, PHP_URL_PATH ), $url );
		$this_host = str_ireplace( 'www.', '', parse_url( home_url(), PHP_URL_HOST ) );
        $file_host = str_ireplace( 'www.', '', parse_url( $url, PHP_URL_HOST ) );
		
		if ( !isset( $parse_url[1] ) || empty( $parse_url[1] ) || ( $this_host != $file_host ) ) {
	    	return;
        }
		
		global $wpdb;
 
        $prefix     = $wpdb->prefix;
        $attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM " . $prefix . "posts WHERE guid RLIKE %s;", $parse_url[1] ) );
		
		return $attachment[0];
    }
	
	function get_additional_user_meta_thumb() {
    	$attachment_url = esc_url( get_the_author_meta( 'user_meta_image', $post->post_author ) );
		$attachment_id = get_attachment_image_by_url( $attachment_url );
		$image_thumb = wp_get_attachment_image_src( $attachment_id, 'thumbnail' );
		return $image_thumb[0];
	}
    
?>