<?php

function theme_pre_set_transient_update_sekolah( $transient ) { 
    // Pastikan transient 'sekolah' ada
    if ( empty( $transient->checked['sekolah'] ) ) {
        return $transient;
    }

    // Ambil data JSON dari server
    $response = wp_safe_remote_get( 'https://update.ciuss.com/wp-content/uploads/sekolah.json', array(
        'timeout' => 3 // Atur waktu tunggu selama 3 detik
    ) );

    // Cek apakah permintaan berhasil
    if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
        $result = wp_remote_retrieve_body( $response );

        // Pastikan data diterima dan tidak kosong
        if ( ! empty( $result ) ) {
            // Decode data JSON
            $data = json_decode( $result );

            // Bandingkan versi server dengan versi yang terpasang
            if ( $data && version_compare( $transient->checked['sekolah'], $data->new_version, '<' ) ) {
                // Perbarui transient dengan data respons
                $transient->response['sekolah'] = (array) $data;
            }
        }
    }

    return $transient;
}
add_filter( 'pre_set_site_transient_update_themes', 'theme_pre_set_transient_update_sekolah' );
