<?php
/**
 * Custom WP sekolah template tags
 * Fungsi pendukung tema WP sekolah
 */
 
if ( ! function_exists( 'preload_sekolah_font' ) ) :
    function preload_sekolah_font() {
        get_template_part('header/meta-preload');
	}
endif;
if ( ! function_exists( 'head_meta_sekolah' ) ) :
    function head_meta_sekolah() {
        get_template_part('header/meta');
	}
endif;
if ( ! function_exists( 'head_meta_desc_akademi' ) ) :
    function head_meta_desc_akademi() {
		if (is_front_page()) {
			bloginfo('description');
		} else if (is_singular()) {
			if (function_exists('smart_excerpt')) smart_excerpt(get_the_excerpt(), 60);
		} else {
			echo '';
		}
	}
endif;
// Logo
if ( ! function_exists( 'custom_logo_sekolah' ) ) :
    function custom_logo_sekolah() {
    	if ( function_exists( 'the_custom_logo' ) ) {
			    the_custom_logo();
	    }
    }
endif;
// Info Sekolah
// Sudah
function sekolah_customize_partial_namasekolah() {
	nama_sekolah();
}
if ( ! function_exists( 'nama_sekolah' ) ) :
	function nama_sekolah() {
		if ( get_theme_mod('nama_sekolah') != "" ) {
	    	echo esc_html(get_theme_mod( 'nama_sekolah')); 
		} else {
			echo 'SMA Negeri 1 Comal - Pemalang';
		}
	}
endif;
// Sudah
function sekolah_customize_partial_address() {
	alamat_sekolah();
}
if ( ! function_exists( 'alamat_sekolah' ) ) :
	function alamat_sekolah() {
		if ( get_theme_mod('address_data') != "" ) {
	        echo esc_html(get_theme_mod( 'address_data')); 
		} else {
			echo 'Jln. Jend A Yani No. 77 Comal, Pemalang, Jawa Tengah';
		}
	}
endif;
// sudah
function sekolah_customize_partial_nspn() {
	sekolah_nspn();
}
if ( ! function_exists( 'sekolah_nspn' ) ) :
	function sekolah_nspn() {
		if ( get_theme_mod('nspn_data') != "" ) {
	        echo esc_html(get_theme_mod( 'nspn_data')); 
		} else {
			echo '20404xxx';
		}
	}
endif;
function sekolah_customize_partial_kepalasekolah() {
	nama_kepala_sekolah();
}
if ( ! function_exists( 'nama_kepala_sekolah' ) ) :
	function nama_kepala_sekolah() {
		if ( get_theme_mod('kepala_sekolah') != "" ) {
	    	echo esc_html(get_theme_mod( 'kepala_sekolah')); 
		} else {
			echo 'Yayun Ciuss'; 
		}
	}
endif;
function sekolah_customize_partial_fotokepala() {
	foto_kepala_sekolah();
}
if ( ! function_exists( 'foto_kepala_sekolah' ) ) :
	function foto_kepala_sekolah() {
		if ( get_theme_mod('foto_kepala') != "" ) {
	    	echo '<img src="'.get_theme_mod( 'foto_kepala').'" />'; 
		} else {
			echo '<img src="'.get_theme_file_uri('gambar/master.jpg').'" />'; 
		}
	}
endif;
function sekolah_customize_partial_number() {
	sekolah_school_number();
}
if ( ! function_exists( 'sekolah_school_number' ) ) :
	function sekolah_school_number() {
		if ( get_theme_mod('telpon_data') != "" ) {
			$tel = get_theme_mod('telpon_data'); 
			$new_tel = preg_replace("/[^A-Za-z0-9?!]/",'',$tel);
	    	echo '<a target="_blank" href="tel:'. $new_tel .'">'. get_theme_mod( 'telpon_data' ) .'</a>';
		} else {
			echo '<a target="_blank" href="tel:000000000">62 8000 xxx</a>';
		}
	}
endif;
function sekolah_customize_partial_mailing() {
	sekolah_school_email();
}
if ( ! function_exists( 'sekolah_school_email' ) ) :
	function sekolah_school_email() {
		if ( get_theme_mod('email_data') != "" ) {
	    	echo '<a target="_blank" href="mailto:'. get_theme_mod('email_data') .'">'. get_theme_mod('email_data') .'</a>';
		} else {
			echo '<a target="_blank" href="mailto:sekolah@sekolah.ciuss">sekolah@sekolah.ciuss</a>';
		}
	}
endif;	
function sekolah_customize_partial_email() {
	sekolah_social_icon();
}
function sekolah_customize_partial_wanumber() {
	sekolah_social_icon();
}
function sekolah_customize_partial_facebook() {
	sekolah_social_icon();
}
function sekolah_customize_partial_twitter() {
	sekolah_social_icon();
}
function sekolah_customize_partial_instagram() {
	sekolah_social_icon();
}
function sekolah_customize_partial_youtube() {
	sekolah_social_icon();
}
if ( ! function_exists( 'sekolah_social_icon' ) ) :
	function sekolah_social_icon() {
		if ( get_theme_mod('facebook_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'facebook_data' ) .'" target="_blank"><i class="icon-mad-facebook"></i></a>';
	    }
		if ( get_theme_mod('twitter_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'twitter_data' ) .'" target="_blank"><i class="icon-mad-twitter"></i></a>';
	    }
		if ( get_theme_mod('instagram_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'instagram_data' ) .'" target="_blank"><i class="icon-mad-instagram"></i></a>';
	    }
		if ( get_theme_mod('youtube_data') != "" ) {
	        echo '<a target="_blank" href="'. get_theme_mod( 'youtube_data' ) .'" target="_blank"><i class="icon-mad-youtube"></i></a>';
	    }
		if ( get_theme_mod('email_data') != "" ) {
	    	echo '<a target="_blank" href="mailto:'. get_theme_mod('email_data') .'"><i class="icon-mad-mail"></i></a>';
		}
		
		if ( get_theme_mod('chat_sekolah') != "" ) {
		     $wa_mess = get_theme_mod('chat_sekolah'); 
	    } else {
	        $wa_mess = 'Saya ingin bertanya seputar sekolah ini..'; 
	    }
		if ( get_theme_mod('wa_data') != "" ) {
			$was = get_theme_mod('wa_data'); 
			$new_was = preg_replace("/[^A-Za-z0-9?!]/",'',$was);
	    	echo '<a target="_blank" href="'. esc_url( 'https://wa.me/'. $new_was .'/?text='. $wa_mess ).'"><i class="icon-mad-whatsapp"></i></a>';
        }
	}
endif;
// Text Berjalan
function sekolah_customize_partial_running() {
	call_running_text();
}
if ( ! function_exists( 'call_running_text' ) ) :
	function call_running_text() {
	    echo '<div class="running__text">';
	    if ( get_theme_mod( 'running_text' ) != "" ) {
        	$string = get_theme_mod( 'running_text' );
			// Menghapus tag HTML dan kode shortcode dari string
			$stringWithoutHTMLAndShortcode = preg_replace('/\[.*?\]/', '', strip_tags($string));
			// Menghitung jumlah kata dalam string yang sudah dibersihkan dari tag HTML dan kode shortcode
			$wordCount = str_word_count($stringWithoutHTMLAndShortcode);
			?>
			
			<ul class="scrolling">
		    	<li class="scroll__number">
				    <?php 
				    	if ( $wordCount < 2 ) {
							for ($i = 0; $i < 45; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 3 ) {
							for ($i = 0; $i < 30; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 4 ) {
							for ($i = 0; $i < 22; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 5 ) {
							for ($i = 0; $i < 18; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 6 ) {
							for ($i = 0; $i < 15; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 7 ) {
							for ($i = 0; $i < 12; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 8 ) {
							for ($i = 0; $i < 11; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 9 ) {
							for ($i = 0; $i < 10; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 10 ) {
							for ($i = 0; $i < 9; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 11 ) {
							for ($i = 0; $i < 8; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 13 ) {
							for ($i = 0; $i < 7; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 15 ) {
							for ($i = 0; $i < 6; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 19 ) {
							for ($i = 0; $i < 5; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 24 ) {
							for ($i = 0; $i < 4; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 35 ) {
							for ($i = 0; $i < 3; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 52 ) {
							for ($i = 0; $i < 2; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 65 ) {
							for ($i = 0; $i < 1; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						}
					?>
			    </li>
	        	<li class="scroll__number">
	                <?php 
				    	if ( $wordCount < 2 ) {
							for ($i = 0; $i < 45; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 3 ) {
							for ($i = 0; $i < 30; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 4 ) {
							for ($i = 0; $i < 22; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 5 ) {
							for ($i = 0; $i < 18; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 6 ) {
							for ($i = 0; $i < 15; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 7 ) {
							for ($i = 0; $i < 12; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 8 ) {
							for ($i = 0; $i < 11; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 9 ) {
							for ($i = 0; $i < 10; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 10 ) {
							for ($i = 0; $i < 9; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 11 ) {
							for ($i = 0; $i < 8; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 13 ) {
							for ($i = 0; $i < 7; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 15 ) {
							for ($i = 0; $i < 6; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 19 ) {
							for ($i = 0; $i < 5; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 24 ) {
							for ($i = 0; $i < 4; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 35 ) {
							for ($i = 0; $i < 3; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 52 ) {
							for ($i = 0; $i < 2; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						} else if ( $wordCount < 65 ) {
							for ($i = 0; $i < 1; $i++) {
								echo '<span>'. esc_html( get_theme_mod( 'running_text' ) ).'</span>';
							}
						}
					?>
				</li>
        	</ul>
			<?php
		} else {
			?>
			<ul class="scrolling">
		    	<li class="scroll__number">
				    <span>Tema WP Sekolah dapat menampilkan informasi dalam text berjalan</span>
				</li>
		    	<li class="scroll__number">
				    <span>Tema WP Sekolah dapat menampilkan informasi dalam text berjalan</span>
				</li>
			</ul>
			<?php	
		}
		echo '</div>';
	}
endif;
/* Replace Text
------------------------------- */
function sekolah_customize_partial_reinfo() {
	sekolah_re_kepsek();
}
if ( ! function_exists( 'sekolah_re_kepsek' ) ) :
	function sekolah_re_kepsek() {
		if ( get_theme_mod('re_kepsek') != "" ) { 
		    echo esc_html(get_theme_mod('re_kepsek'));
		} else {
			echo 'Kepala Sekolah';
		}
	}
endif;
function sekolah_customize_partial_editorial() {
	sekolah_re_editorial();
}
if ( ! function_exists( 'sekolah_re_editorial' ) ) :
	function sekolah_re_editorial() {
		if ( get_theme_mod('re_editorial') != "" ) { 
		    echo esc_html(get_theme_mod('re_editorial'));
		} else {
			echo 'Editorial Kepsek';
		}
	}
endif;
function sekolah_customize_partial_editormore() {
	sekolah_re_editormore();
}
if ( ! function_exists( 'sekolah_re_editormore' ) ) :
	function sekolah_re_editormore() {
		if ( get_theme_mod('re_editormore') != "" ) { 
		    echo esc_html(get_theme_mod('re_editormore'));
		} else {
			echo 'Lihat Semua';
		}
	}
endif;
function sekolah_customize_partial_renews() {
	sekolah_re_news();
}
if ( ! function_exists( 'sekolah_re_news' ) ) :
	function sekolah_re_news() {
		if ( get_theme_mod('re_news') != "" ) { 
		    echo esc_html(get_theme_mod('re_news'));
		} else {
			echo 'Berita Terbaru';
		}
	}
endif;
function sekolah_customize_partial_requotes() {
	sekolah_re_quotes();
}
if ( ! function_exists( 'sekolah_re_quotes' ) ) :
	function sekolah_re_quotes() {
		if ( get_theme_mod('re_quotes') != "" ) { 
		    echo esc_html(get_theme_mod('re_quotes'));
		} else {
			echo 'Kata Bijak';
		}
	}
endif;
function sekolah_customize_partial_regurus() {
	sekolah_re_gurus();
}
if ( ! function_exists( 'sekolah_re_gurus' ) ) :
	function sekolah_re_gurus() {
		if ( get_theme_mod('re_gurus') != "" ) { 
		    echo esc_html(get_theme_mod('re_gurus'));
		} else {
			echo 'Guru-Guru Keren';
		}
	}
endif;
function sekolah_customize_partial_announ() {
	sekolah_re_peng();
}
if ( ! function_exists( 'sekolah_re_peng' ) ) :
	function sekolah_re_peng() {
		if ( get_theme_mod('re_pengumuman') != "" ) { 
		    echo esc_html(get_theme_mod('re_pengumuman'));
		} else {
			echo 'Pengumuman';
		}
	}
endif;
function sekolah_customize_partial_reagenda() {
	sekolah_re_agenda();
}
if ( ! function_exists( 'sekolah_re_agenda' ) ) :
	function sekolah_re_agenda() {
		if ( get_theme_mod('re_agenda') != "" ) { 
		    echo esc_html(get_theme_mod('re_agenda'));
		} else {
			echo 'Agenda Terbaru';
		}
	}
endif;
function sekolah_customize_partial_reblog() {
	sekolah_re_blog();
}
if ( ! function_exists( 'sekolah_re_blog' ) ) :
	function sekolah_re_blog() {
		if ( get_theme_mod('re_blog') != "" ) { 
		    echo esc_html(get_theme_mod('re_blog'));
		} else {
			echo 'Blog Guru';
		}
	}
endif;
function sekolah_customize_partial_rekegiatan() {
	sekolah_re_kegiatan();
}
if ( ! function_exists( 'sekolah_re_kegiatan' ) ) :
	function sekolah_re_kegiatan() {
		if ( get_theme_mod('re_kegiatan') != "" ) { 
		    echo esc_html(get_theme_mod('re_kegiatan'));
		} else {
			echo 'Kegiatan';
		}
	}
endif;
function sekolah_customize_partial_refasilitas() {
	sekolah_re_fasilitas();
}
if ( ! function_exists( 'sekolah_re_fasilitas' ) ) :
	function sekolah_re_fasilitas() {
		if ( get_theme_mod('re_fasilitas') != "" ) { 
		    echo esc_html(get_theme_mod('re_fasilitas'));
		} else {
			echo 'Fasilitas';
		}
	}
endif;	
function sekolah_customize_partial_re_galeri() {
	sekolah_re_galeri();
}
if ( ! function_exists( 'sekolah_re_galeri' ) ) :
	function sekolah_re_galeri() {
		if ( get_theme_mod('re_galeri') != "" ) { 
		    echo esc_html(get_theme_mod('re_galeri'));
		} else {
			echo 'Galeri';
		}
	}
endif;	
function sekolah_customize_partial_re_video() {
	sekolah_re_video();
}
if ( ! function_exists( 'sekolah_re_video' ) ) :
	function sekolah_re_video() {
		if ( get_theme_mod('re_video') != "" ) { 
		    echo esc_html(get_theme_mod('re_video'));
		} else {
			echo 'Video';
		}
	}
endif;
// Sudah
if ( ! function_exists( 'sekolah_home_slider' ) ) :
    function sekolah_home_slider() {
		if (is_front_page()) {  
	        get_template_part('header/slider');
		}
	}
endif;
// Sudah
if ( ! function_exists( 'slide_time_out' ) ) :
    function slide_time_out() {
		$permile = 1000;
		$perslide = get_theme_mod('slide_timer');
		$time_out_slide = $permile * $perslide;
		if ( get_theme_mod('slide_timer') != "" ) {
	    	echo $time_out_slide; 
		} else {
			echo 6000;
		}
	}
endif;
		
if ( ! function_exists( 're_search_download' ) ) :
	function re_search_download() {
		if ( get_theme_mod('re_sedown') != "" ) {
	    	echo html_entity_decode(get_theme_mod( 're_sedown' )); 
		} else {
		    echo 'Hasil pencarian akan muncul disini';	
		}
	}
endif;
function sekolah_customize_partial_represtasi() {
	sekolah_re_prestasi();
}
if ( ! function_exists( 'sekolah_re_prestasi' ) ) :
	function sekolah_re_prestasi() {
		if ( get_theme_mod('re_prestasi') != "" ) { 
		    echo esc_html(get_theme_mod('re_prestasi'));
		} else {
			echo 'Prestasi';
		}
	}
endif;
function sekolah_customize_partial_headnot() {
	sekolah_head_not_found();
}
if ( ! function_exists( 'sekolah_head_not_found' ) ) :
	function sekolah_head_not_found() {
		if ( get_theme_mod('re_head') != "" ) { 
		    echo esc_html(get_theme_mod('re_head'));
		} else {
			echo '404, Halaman tidak ditemukan';
		}
	}
endif;
function sekolah_customize_partial_textnot() {
	sekolah_text_not_found();
}
if ( ! function_exists( 'sekolah_text_not_found' ) ) :
	function sekolah_text_not_found() {
		if ( get_theme_mod('re_text') != "" ) { 
		    echo esc_html(get_theme_mod('re_text'));
		} else {
			echo 'Halaman ini tidak tersedia atau mungkin sudah kadaluarsa';
		}
	}
endif;
// Copyright
function sekolah_customize_partial_footcopy() {
	sekolah_text_footer();
}
if ( ! function_exists( 'sekolah_text_footer' ) ) :
	function sekolah_text_footer() {
		if ( get_theme_mod('copy_foot') != "" ) {
			echo esc_html(get_theme_mod('copy_foot')); 
		} else {
	    	get_template_part('footer/copyright');
		}
	}
endif;
if ( ! function_exists( 'post_related_by_category' ) ) :
	function post_related_by_category() {
		get_template_part('single/related-post');
	}
endif;
if ( ! function_exists( 'post_another_agendas' ) ) :
	function post_another_agendas() {
		get_template_part('single/another-agendas');
	}
endif;
if ( ! function_exists( 'post_another_blogs' ) ) :
	function post_another_blogs() {
		get_template_part('single/another-blogs');
	}
endif;
if ( ! function_exists( 'post_another_editorials' ) ) :
	function post_another_editorials() {
		get_template_part('single/another-editorials');
	}
endif;
if ( ! function_exists( 'post_another_ekskul' ) ) :
	function post_another_ekskul() {
		get_template_part('single/another-ekskul');
	}
endif;
if ( ! function_exists( 'post_another_fasilitas' ) ) :
	function post_another_fasilitas() {
		get_template_part('single/another-fasilitas');
	}
endif;
if ( ! function_exists( 'post_another_galeri' ) ) :
	function post_another_galeri() {
		get_template_part('single/another-galeri');
	}
endif;
if ( ! function_exists( 'post_another_pengumuman' ) ) :
	function post_another_pengumuman() {
		get_template_part('single/another-pengumuman');
	}
endif;
if ( ! function_exists( 'post_another_prestasi' ) ) :
	function post_another_prestasi() {
		get_template_part('single/another-prestasi');
	}
endif;
if ( ! function_exists( 'post_another_slider' ) ) :
	function post_another_slider() {
		get_template_part('single/another-slider');
	}
endif;
if ( ! function_exists( 'post_another_ukm' ) ) :
	function post_another_ukm() {
		get_template_part('single/another-ukm');
	}
endif;
if ( ! function_exists( 'post_another_video' ) ) :
	function post_another_video() {
		get_template_part('single/another-video');
	}
endif;
// sekolah Template Tags
if ( ! function_exists( 'editorial_news' ) ) :
	function editorial_news() {
		get_template_part('beranda/editorial-news');
	}
endif;
if ( ! function_exists( 'three_block' ) ) :
	function three_block() {
		get_template_part('beranda/three-block');
	}
endif;
if ( ! function_exists( 'sekolah_slide_guru' ) ) :
	function sekolah_slide_guru() {
		get_template_part('beranda/slideguru');
	}
endif;
if ( ! function_exists( 'three_bot_block' ) ) :
	function three_bot_block() {
		get_template_part('beranda/three-bottom-block');
	}
endif;
if ( ! function_exists( 'sekolah_video_post' ) ) :
	function sekolah_video_post() {
		get_template_part('beranda/video');
	}
endif;
if ( ! function_exists( 'call_fasilitas_post' ) ) :
	function call_fasilitas_post() {
		get_template_part('beranda/fasilitas');
	}
endif;
if ( ! function_exists( 'call_ekskul_post' ) ) :
	function call_ekskul_post() {
		get_template_part('beranda/ekskul');
	}
endif;
if ( ! function_exists( 'agenda_on_parallax' ) ) :
	function agenda_on_parallax() {
		get_template_part('beranda/agenda');
	}
endif;
if ( ! function_exists( 'sekolah_thumb_gallery' ) ) :
	function sekolah_thumb_gallery() {
		get_template_part('beranda/galeri');
	}
endif;
if ( ! function_exists( 'sekolah_slide_quotes' ) ) :
	function sekolah_slide_quotes() {
		get_template_part('beranda/quotes');
	}
endif;
