<?php
class Videos extends WP_Widget {
	function __construct() {
		parent::__construct(
			'sekolah_widvideo',
			'WP Sekolah : Video Terbaru',
			array( 'description' => 'Widget ini digunakan untuk menampilkan Post Video Terbaru', 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : 'Video Terbaru';

		/** This filter is documented in wp-tambahans/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$vidpost = ( ! empty( $instance['vidpost'] ) ) ? absint( $instance['vidpost'] ) : 3;
		if ( ! $vidpost ) {
			$vidpost = 3;
		}
		
		$q_args = array( 
			'post_type' => 'video', 
			'numberposts' => $vidpost,
			); 
			
		global $post;
		$videopost = get_posts($q_args);
		
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		echo '<div class="wp-block-video">';
		foreach ($videopost as $post):
		    $vidembed = get_post_meta($post->ID, '_vidembed', true); 
			setup_postdata($post);
		?>
		    <figure>
				<?php echo wp_oembed_get( 'https://ciuss.com/tuts-download/'. $vidembed ); ?>
			</figure>
		<?php	
		endforeach;
		echo '</div>';
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['vidpost'] = sanitize_text_field( $new_instance['vidpost'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : 'Video Terbaru';
		$vidpost     = isset( $instance['vidpost'] ) ? esc_attr( $instance['vidpost'] ) : 3; ?>
		<p><?php echo 'Widget ini digunakan untuk menampilkan daftar Video Terbaru terbaru di sidebar'; ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo 'Title :'; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'vidpost' ); ?>"><?php echo 'Jumlah pos :'; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'vidpost' ); ?>" name="<?php echo $this->get_field_name( 'vidpost' ); ?>" type="number" value="<?php echo $vidpost; ?>" /></p>

    <?php
	}
}